﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="global.aspx.cs" Inherits="LVProSimApp.LVProSimAppWebServer" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link rel="Shortcut Icon" href="favicon.ico" type="image/x-icon" />
    <link rel="stylesheet" href="style/global.bundle.min.css" media="screen, print" />

    <!-- LES SCRIPTS SONT MAINTENANT EN BAS DE LA PAGE DANS LA FONCTION AddScripts -->


    <title>LVProSim</title>

    <style type="text/css">
        @font-face {
            font-family: LCD;
            src: url("fonts/LCDMonoItalic.eot") format('truetype'), url("fonts/LCDMonoItalic.eot?#iefix") format('embedded-opentype'), url("fonts/LCDMonoItalic.ttf") format('truetype'), url("fonts/LCDMonoItalic.svg#Digital-7MonoItalic") format('svg');
            font-weight: normal;
            font-style: normal;
        }
    </style>
</head>

<body>
    <%--Hidden logo for the print layout--%>
    <div id="printLogo" style="display: none;">
        <img src="images/logo_festo.png" alt="printLogo" />
    </div>

    <div id="content">
        <div id="header">

            <div id="pleaseWaitTransparent"><span id="pleaseWaitText" class="translatableElement"></span></div>

            <div id="largeMenuBar">
                <div id="largeMenuBarFiller"></div>
                <a id="labVoltLink" class="translatableElement" href="http://www.labvolt.com" target="_blank" title="Open a new window to the Lab-Volt website">
                    <img id="logo" src="images/logo_festo.png" alt="Lab-Volt" /></a>
                <div id="fileMenu" class="largeMenuBarElement">
                    <span id="fileMenuText" class="menuText translatableElement"></span>
                    <div id="fileDropDownMenu" class="dropDownMenu">
                        <div id="newMenuOption" class="dropDownMenuOption" onclick="newPage()"><span id="newMenuOptionText" class="menuText translatableElement"></span></div>
                        <div id="loadMenuOption" class="dropDownMenuOption"><span id="loadMenuOptionText" class="menuText translatableElement"></span></div>
                        <div id="saveMenuOption" class="dropDownMenuOption"><span id="saveMenuOptionText" class="menuText translatableElement"></span></div>
                        <div id="exportMenuOption" class="dropDownMenuOption" onclick="exportGraphData()"><span id="exportMenuOptionText" class="menuText translatableElement"></span></div>
                        <hr class="menuBarSpacer" />
                        <div id="printMenuOption" class="dropDownMenuOption" onclick="window.print()"><span id="printMenuOptionText" class="menuText translatableElement"></span></div>
                    </div>
                </div>
                <div id="viewMenu" class="largeMenuBarElement">
                    <span id="viewMenuText" class="menuText translatableElement"></span>
                    <div id="viewDropDownMenu" class="dropDownMenu">
                        <div id="meterMenuOption" class="dropDownMenuOption selectedMenuBarElement" onclick="showHidePanel('leftMeteringPanel', 'meterMenuOption', 'toggleInnerLeftPanelButton', 'toggleOuterLeftPanelButton')">
                            <span id="meterMenuOptionText" class="menuText translatableElement"></span>
                        </div>
                        <div id="PIDControllersMenuOption" class="dropDownMenuOption selectedMenuBarElement" onclick="showHidePanel('rightToolBar', 'PIDControllersMenuOption', 'toggleInnerRightPanelButton', 'toggleOuterRightPanelButton')">
                            <span id="PIDControllersMenuOptionText" class="menuText translatableElement"></span>
                        </div>
                        <div id="graphSettingsMenuOption" class="dropDownMenuOption selectedMenuBarElement" onclick="showHidePanel('trendRecorderUserSettings', 'graphSettingsMenuOption', 'toggleTrendSettingsPanelButton', 'toggleOuterTrendSettingsPanelButton')">
                            <span id="graphSettingsMenuOptionText" class="menuText translatableElement"></span>
                        </div>
                    </div>
                </div>
                <div id="graphMenu" class="largeMenuBarElement">
                    <span id="graphMenuText" class="menuText translatableElement"></span>
                    <div id="graphDropDownMenu" class="dropDownMenu">
                        <div id="playMenuOption" class="dropDownMenuOption" onclick="turnGraphOn()"><span id="playMenuOptionText" class="menuText translatableElement"></span></div>
                        <div id="pauseMenuOption" class="dropDownMenuOption" onclick="turnGraphOff()"><span id="pauseMenuOptionText" class="menuText translatableElement"></span></div>
                        <div id="resetMenuOption" class="dropDownMenuOption" onclick="resetGraph()"><span id="resetMenuOptionText" class="menuText translatableElement"></span></div>
                    </div>
                </div>
                <div id="settingsMenu" class="largeMenuBarElement">
                    <span id="settingsMenuText" class="menuText translatableElement"></span>
                    <div id="settingsDropDownMenu" class="dropDownMenu">
                        <div id="setLanguageMenuOption" class="dropDownMenuOption menuBarSubElement">
                            <span id="setLanguageMenuOptionText" class="menuText translatableElement"></span>
                            <div class="subDropDownMenu">
                                <div class="dropDownMenuOption selectedMenuBarElement" data-lang="en" onclick="onChangeLanguage(event)"><span id="subMenuEnglishText" class="menuText translatableElement"></span></div>
                                <div class="dropDownMenuOption" data-lang="fr" onclick="onChangeLanguage(event)"><span id="subMenuFrenchText" class="menuText translatableElement"></span></div>
                                <div class="dropDownMenuOption" data-lang="es" onclick="onChangeLanguage(event)"><span id="subMenuSpanishText" class="menuText translatableElement"></span></div>
                            </div>
                        </div>
                        <hr class="menuBarSpacer" style="display: none;" />
                        <div id="setIntervalMenuOption" class="dropDownMenuOption menuBarSubElement">
                            <span id="setIntervalMenuOptionText" class="menuText translatableElement"></span>
                            <div class="subDropDownMenu">
                                <div class="dropDownMenuOption" data-inter="100" onclick="onChangeInterval(event)"><span id="subMenuInt100Text" class="menuText translatableElement"></span></div>
                                <div class="dropDownMenuOption selectedMenuBarElement" data-inter="200" onclick="onChangeInterval(event)"><span id="subMenuInt200Text" class="menuText translatableElement"></span></div>
                                <div class="dropDownMenuOption" data-inter="500" onclick="onChangeInterval(event)"><span id="subMenuInt500Text" class="menuText translatableElement"></span></div>
                                <div class="dropDownMenuOption" data-inter="1000" onclick="onChangeInterval(event)"><span id="subMenuInt1000Text" class="menuText translatableElement"></span></div>
                            </div>
                        </div>
                        <hr class="menuBarSpacer" />
                        <div id="setChannelsMenuOption" class="dropDownMenuOption moduleModeOnly" onclick="onClickOpenSetChannelDialog()"><span id="setChannelsMenuOptionText" class="menuText translatableElement"></span></div>
                        <div id="setFunctionsMenuOption" class="dropDownMenuOption" onclick="onClickOpenSetFunctionDialog()"><span id="setFunctionsMenuOptionText" class="menuText translatableElement"></span></div>
                    </div>
                </div>
                <div id="simulatorsMenu" class="largeMenuBarElement">
                    <span id="simulatorsMenuText" class="menuText translatableElement"></span>
                </div>
                <div id="helpMenu" class="largeMenuBarElement">
                    <span id="helpMenuText" class="menuText translatableElement"></span>
                    <div id="helpDropDownMenu" class="dropDownMenu">
                        <div id="contentsMenuOption" class="dropDownMenuOption" onclick="downloadHelpPDF()"><span id="contentsMenuOptionText" class="menuText translatableElement"></span></div>                       				    
                        <hr class="menuBarSpacer" />
                        <div id="checkForUpdateMenuOption" class="dropDownMenuOption" onclick="checkForUpdate(true)"><span id="checkForUpdateMenuOptionText" class="menuText translatableElement"></span></div>  
                        <hr class="menuBarSpacer" />
                        <div id="aboutMenuOption" class="dropDownMenuOption" onclick="openAboutMenu()"><span id="aboutMenuOptionText" class="menuText translatableElement"></span></div>
                    </div>
                </div>
            </div>
            <div id="largeToolBar">
                <div id="largeToolBarFiller"></div>
                <div id="toolbarContainer">
                    <div id="newButton" class="largeToolBarButton translatableElement" onclick="newPage()" title="">
                        <img class="largeToolBarImage" src="images/global/new.png" alt="New" />
                    </div>

                    <div id="loadButton" class="largeToolBarButton translatableElement" title="">
                        <img class="largeToolBarImage" src="images/global/load.png" alt="Open" />
                    </div>
                    <div id="saveToolBarButton" class="largeToolBarButton translatableElement" title="">
                        <img class="largeToolBarImage" src="images/global/save.png" alt="Save" />
                    </div>

                    <div id="exportToolBarButton" class="largeToolBarButton translatableElement" onclick="exportGraphData()" title="">
                        <img class="largeToolBarImage" src="images/global/export.png" alt="Export" />
                    </div>
                    <div id="printButton" class="largeToolBarButton translatableElement" onclick="window.print()" title="">
                        <img class="largeToolBarImage" src="images/global/print.png" alt="Print" />
                    </div>
                    <div class="largeToolBarSeparator"></div>
                    <div id="playButton" class="largeToolBarButton translatableElement" onclick="turnGraphOn()" title="">
                        <img class="largeToolBarImage" src="images/global/play.png" alt="Play" />
                    </div>
                    <div id="pauseButton" class="largeToolBarButton translatableElement" onclick="turnGraphOff()" title="">
                        <img class="largeToolBarImage" src="images/global/pause.png" alt="Pause" />
                    </div>

                    <div id="resetButton" class="largeToolBarButton translatableElement" onclick="resetGraph()" title="">
                        <img class="largeToolBarImage" src="images/global/clear.png" alt="Reset" />
                    </div>
                    <div class="largeToolBarSeparator"></div>
                    <div id="setChannelsButton" class="largeToolBarButton moduleModeOnly translatableElement" onclick="onClickOpenSetChannelDialog()" title="">
                        <img class="largeToolBarImage" src="images/global/channel.png" alt="Set Channels" />
                    </div>
                    <div id="setFunctionsButton" class="largeToolBarButton translatableElement" onclick="onClickOpenSetFunctionDialog()" title="">
                        <img class="largeToolBarImage" src="images/global/functions.png" alt="Set Functions" />
                    </div>

                    <div id="setGenFunctionsButton" class="largeToolBarButton translatableElement" onclick="onClickOpenSetGeneratorDialog()" title="">
                        <img class="largeToolBarImage" src="images/global/func-generator.png" alt="Set Generator" />
                    </div>

                    <div id="simulatorButton" class="largeToolBarButton translatableElement" title="">
                        <img class="largeToolBarImage" src="images/global/simulator.png" alt="Simulator" />
                    </div>
                    <div class="largeToolBarSeparator moduleModeOnly"></div>

                    <div id="digitalIContainer" class="toolbarContainer moduleModeOnly">
                        <div class="digitalIOSubContainer">
                            <div style="position: relative;">
                                <div class="digitalIOLabel moduleModeOnly"><span id="digitalILabel" class="translatableElement">Digital Inputs</span></div>
                            </div>
                            <div id="digitalInput0" title="" class="digitalInputLED moduleModeOnly translatableElement">
                                <div class="digitalIONumber">1</div>
                            </div>
                            <div id="digitalInput1" title="" class="digitalInputLED moduleModeOnly translatableElement">
                                <div class="digitalIONumber">2</div>
                            </div>
                            <div id="digitalInput2" title="" class="digitalInputLED moduleModeOnly translatableElement">
                                <div class="digitalIONumber">3</div>
                            </div>
                            <div id="digitalInput3" title="" class="digitalInputLED moduleModeOnly translatableElement">
                                <div class="digitalIONumber">4</div>
                            </div>
                        </div>
                    </div>
                    <div class="largeToolBarSeparator moduleModeOnly"></div>
                    <div id="digitalOContainer" class="toolbarContainer moduleModeOnly">
                        <div class="digitalIOSubContainer">
                            <div style="position: relative;">
                                <div class="digitalIOLabel moduleModeOnly"><span id="digitalOLabel" class="translatableElement">Digital Outputs</span></div>
                            </div>
                            <div id="digitalOutput0" title="" class="digitalInputLED digitalOutputLED moduleModeOnly translatableElement" onclick="sendToggleOutput(0,'digitalOutput0')">
                                <div class="digitalIONumber">1</div>
                            </div>
                            <div id="digitalOutput1" title="" class="digitalInputLED digitalOutputLED moduleModeOnly translatableElement" onclick="sendToggleOutput(1, 'digitalOutput1')">
                                <div class="digitalIONumber">2</div>
                            </div>
                        </div>
                    </div>

                    <div class="largeToolBarSeparator moduleModeOnly"></div>

                    <div id="emergencyContainer" class="moduleModeOnly translatableElement" title="">
                        <button type="button" id="emergencyButton" class="translatableElement" onclick="emergencyStopAjax()"></button>
                    </div>
                </div>
                <div id="connexionToolbarContainer" class="toolbarContainer">
                    <span id="connexionLabel" class="translatableElement toolbarText"></span>
                    <img id="connexionIndicator" src="images/global/no-connexion.png" alt="Acquisition Status">
                </div>
            </div>
        </div>

        <form id="aspForm" runat="server" style="display: none">
            <asp:Button ID="saveFileBtn" runat="server" CommandArgument="" OnClick="DownloadSaveFile" />
        </form>
        <div id="saveDialog" title="" class="dialog translatableElement" style="display: none;">
            <span id="saveFilenameLabel" class="translatableElement"></span>
            <br />
            <input type="text" id="dialogSaveFilename" />
            <br />
            <p id="wrongFileFormatMessage" style="display: none; color: red; font-size: small"><span id="saveFilenameError" class="translatableElement"></span></p>
        </div>

        <div id="loadDialog" title="" class="dialog translatableElement">
            <div id="loadFromServerGroup">
                <input id="loadFromServerRadio" type="radio" name="loadRadioGroup" value="Server" class="loadDialogRadio" />
                <span id="loadFromServerLabel" class="translatableElement loadRadioLabel" onclick="$('#loadFromServerRadio').click()"></span>
                <select id="serverFileSelect" multiple="multiple" disabled="disabled"></select>
            </div>
            <div id="loadFromLocalGroup">
                <input id="loadFromLocalRadio" type="radio" name="loadRadioGroup" value="Local" checked="checked" class="loadDialogRadio" />
                <span id="loadFromLocalLabel" class="translatableElement loadRadioLabel" onclick="$('#loadFromLocalRadio').click()"></span>
                <input type="file" id="fileUpload" accept=".LVProSim" />
            </div>
            <span id="loadDialogErrorMessage" class="translatableElement" style="color: red; display: none;"></span>
        </div>

        <div id="rightToolBar" class="customPanel">
            <div class="panelTitleContainer trendRecorderSettingsTitle">
                <span id="PIDPanelTitleText" class="translatableElement"></span>
                <div id="toggleInnerRightPanelButton" class="toggleButton leftSideButton" onclick="showHidePanel('rightToolBar', 'PIDControllersMenuOption', 'toggleInnerRightPanelButton', 'toggleOuterRightPanelButton')">
                    <div class="buttonShape arrow-right"></div>
                </div>
            </div>
            <div>
                <div id="pidPanel1" class="PIDPanel customPanel"></div>
                <div id="pidPanel2" class="PIDPanel customPanel"></div>
            </div>
        </div>
        <div id="toggleOuterRightPanelButton" class="outerRightPanelButton translatableElement" title="" onclick="showHidePanel('rightToolBar', 'PIDControllersMenuOption', 'toggleInnerRightPanelButton', 'toggleOuterRightPanelButton')">
            <div class="toggleArrow arrow-left-large"></div>
        </div>

        <div id="leftMeteringPanel" class="customPanel">
            <div class="panelTitleContainer trendRecorderSettingsTitle">
                <span id="MeterPanelTitleText" class="translatableElement"></span>
                <div id="toggleInnerLeftPanelButton" class="toggleButton rightSideButton" onclick="showHidePanel('leftMeteringPanel', 'meterMenuOption', 'toggleInnerLeftPanelButton', 'toggleOuterLeftPanelButton')">
                    <div class="buttonShape arrow-left"></div>
                </div>
            </div>
            <div id="metersContainer"></div>
            <%--<input type="button" id="createMeterButton" class="customButton translatableElement" onclick="showCreateMeterDialog()" value="Add Meter" />--%>
            <input type="button" id="createMeterButton" class="customButton translatableElement" onclick="showCreateMeterDialog()" value="Add Meter" />
            <input type="button" id="createTotalizerButton" class="customButton translatableElement moduleModeOnly" onclick="showCreateTotalizerDialog()" value="Add Totalizer" />
        </div>
        <div id="toggleOuterLeftPanelButton" class="outerLeftPanelButton translatableElement" title="" onclick="showHidePanel('leftMeteringPanel', 'meterMenuOption', 'toggleInnerLeftPanelButton', 'toggleOuterLeftPanelButton')">
            <div class="toggleArrow arrow-right-large"></div>
        </div>

        <div id="mainContent">
            <div id="centeredContainer">
                <div id="graphContainer" class="no-select">
                    <div id="graphStepsContainer"></div>
                    <div id="trendRecorder">
                        <div id="cursorX1" class="cursorX cursor1">
                            <div class="cursorXHandle cursor1"><span class="cursorText">X1</span></div>
                        </div>
                        <div id="cursorX2" class="cursorX cursor2">
                            <div class="cursorXHandle cursor2"><span class="cursorText">X2</span></div>
                        </div>
                        <div id="cursorY1" class="cursorY cursor1">
                            <div class="cursorYHandle cursor1"><span class="cursorText">Y1</span></div>
                        </div>
                        <div id="cursorY2" class="cursorY cursor2">
                            <div class="cursorYHandle cursor2"><span class="cursorText">Y2</span></div>
                        </div>
                        <div id="SVGContainer">
                            <svg id="gridContainer" class="graph" version="1.1" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 700 450">
                                <rect width="100%" height="100%" fill="none" stroke="lightgray" stroke-width="1"></rect>
                                <g class="grid vertical-grid">
                                    <line x1="70" y1="0" x2="70" y2="450"></line>
                                    <line x1="140" y1="0" x2="140" y2="450"></line>
                                    <line x1="210" y1="0" x2="210" y2="450"></line>
                                    <line x1="280" y1="0" x2="280" y2="450"></line>
                                    <line x1="350" y1="0" x2="350" y2="450"></line>
                                    <line x1="420" y1="0" x2="420" y2="450"></line>
                                    <line x1="490" y1="0" x2="490" y2="450"></line>
                                    <line x1="560" y1="0" x2="560" y2="450"></line>
                                    <line x1="630" y1="0" x2="630" y2="450"></line>
                                </g>
                                <g class="grid horizontal-grid">
                                    <line x1="0" y1="45" x2="700" y2="45"></line>
                                    <line x1="0" y1="90" x2="700" y2="90"></line>
                                    <line x1="0" y1="135" x2="700" y2="135"></line>
                                    <line x1="0" y1="180" x2="700" y2="180"></line>
                                    <line x1="0" y1="225" x2="700" y2="225"></line>
                                    <line x1="0" y1="270" x2="700" y2="270"></line>
                                    <line x1="0" y1="315" x2="700" y2="315"></line>
                                    <line x1="0" y1="360" x2="700" y2="360"></line>
                                    <line x1="0" y1="405" x2="700" y2="405"></line>
                                </g>
                                <g id="tracesContainer"></g>
                            </svg>
                        </div>
                    </div>

                    <div id="graphTimeContainer">
                        <svg class="graph" version="1.1" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">
                            <g id="timeScaleLines" class="steps x-steps">
                                <line id="timeLine1" x1="30" y1="0" x2="30" y2="5"></line>
                                <line id="timeLine2" x1="100" y1="0" x2="100" y2="5"></line>
                                <line id="timeLine3" x1="170" y1="0" x2="170" y2="5"></line>
                                <line id="timeLine4" x1="240" y1="0" x2="240" y2="5"></line>
                                <line id="timeLine5" x1="310" y1="0" x2="310" y2="5"></line>
                                <line id="timeLine6" x1="380" y1="0" x2="380" y2="5"></line>
                                <line id="timeLine7" x1="450" y1="0" x2="450" y2="5"></line>
                                <line id="timeLine8" x1="520" y1="0" x2="520" y2="5"></line>
                                <line id="timeLine9" x1="590" y1="0" x2="590" y2="5"></line>
                                <line id="timeLine10" x1="660" y1="0" x2="660" y2="5"></line>
                                <line id="timeLine11" x1="730" y1="0" x2="730" y2="5"></line>
                            </g>
                            <g id="timeScaleLabels" class="labels x-labels">
                                <text id="timeLabel1" class="timeLabels" x="30" y="25"></text>
                                <text id="timeLabel2" class="timeLabels" x="100" y="25"></text>
                                <text id="timeLabel3" class="timeLabels" x="170" y="25"></text>
                                <text id="timeLabel4" class="timeLabels" x="240" y="25"></text>
                                <text id="timeLabel5" class="timeLabels" x="310" y="25"></text>
                                <text id="timeLabel6" class="timeLabels" x="380" y="25"></text>
                                <text id="timeLabel7" class="timeLabels" x="450" y="25"></text>
                                <text id="timeLabel8" class="timeLabels" x="520" y="25"></text>
                                <text id="timeLabel9" class="timeLabels" x="590" y="25"></text>
                                <text id="timeLabel10" class="timeLabels" x="660" y="25"></text>
                                <text id="timeLabel11" class="timeLabels" x="730" y="25"></text>
                            </g>
                        </svg>
                    </div>
                </div>

                <div id="printTextContainer" style="display: none;">
                    <div id="printPID1Settings">
                        <div id="printPID1Manual">
                            <span id="printOutput1Label" class="labelText translatableElement"></span>
                            <span id="printOutput1Value" class="labelText"></span>
                        </div>
                        <div id="printPID1Automatic" style="display: none;">
                            <span id="printProportional1Label" class="labelText translatableElement"></span>
                            <span id="printProportional1Value" class="labelText"></span>
                            <span id="printProportional1Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printIntegral1Label" class="labelText translatableElement"></span>
                            <span id="printIntegral1Value" class="labelText"></span>
                            <span id="printIntegral1Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printDerivative1Label" class="labelText translatableElement"></span>
                            <span id="printDerivative1Value" class="labelText"></span>
                            <span id="printDerivative1Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printSetPoint1Label" class="labelText translatableElement"></span>
                            <span id="printSetPoint1Value" class="labelText"></span>
                            <span id="printSetPoint1Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printProcess1Label" class="labelText translatableElement"></span>
                            <span id="printProcess1Value" class="labelText"></span>
                            <span id="printProcess1Unit" class="labelText translatableElement"></span>
                        </div>
                    </div>
                    <div id="printPID2Settings">
                        <div id="printPID2Manual">
                            <span id="printOutput2Label" class="labelText translatableElement"></span>
                            <span id="printOutput2Value" class="labelText"></span>
                        </div>
                        <div id="printPID2Automatic" style="display: none;">
                            <span id="printProportional2Label" class="labelText translatableElement"></span>
                            <span id="printProportional2Value" class="labelText"></span>
                            <span id="printProportional2Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printIntegral2Label" class="labelText translatableElement"></span>
                            <span id="printIntegral2Value" class="labelText"></span>
                            <span id="printIntegral2Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printDerivative2Label" class="labelText translatableElement"></span>
                            <span id="printDerivative2Value" class="labelText"></span>
                            <span id="printDerivative2Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printSetPoint2Label" class="labelText translatableElement"></span>
                            <span id="printSetPoint2Value" class="labelText"></span>
                            <span id="printSetPoint2Unit" class="labelText translatableElement"></span>
                            <br />
                            <span id="printProcess2Label" class="labelText translatableElement"></span>
                            <span id="printProcess2Value" class="labelText"></span>
                            <span id="printProcess2Unit" class="labelText translatableElement"></span>
                        </div>

                    </div>

                </div>

            </div>
        </div>
        <div id="trendRecorderDataValues">
            <div id="dataValuesContainer">
                <div id="dataValuesRowsNameLine">
                    <div id="dataValuesEnableLabel" class="dataValuesRowsName dataValuesEnable titleText"></div>
                    <div class="dataValuesRowsName dataValuesName titleText"><span id="dataValuesNameLabel" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesCursorX1 titleText"><span id="dataValuesCursorX1Label" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesCursorX2 titleText"><span id="dataValuesCursorX2Label" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesSlope titleText"><span id="dataValuesSlopeLabel" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesCursorY1 titleText"><span id="dataValuesCursorY1Label" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesCursorY2 titleText"><span id="dataValuesCursorY2Label" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesUnit titleText"><span id="dataValuesUnitLabel" class="translatableElement"></span></div>
                    <div class="dataValuesRowsName dataValuesColor titleText"><span id="dataValuesColorLabel" class="translatableElement"></span></div>
                    <div id="dataValuesDeleteLabel" class="dataValuesRowsName dataValuesDelete titleText">X</div>
                </div>
                <div id="dataValuesLinesContainer"></div>
                <div id="dataValuesAddLine">
                    <input type="button" id="newDataValueBtn" class="customButton translatableElement" onclick="onClickNewDataValue()" value="" />
                    <select id="newDataSelector" class="inputField" style="color: black;">
                        <%--dynamic filling--%> 
                    </select>
                </div>
            </div>

            <div id="trendRecorderUserSettings" class="customPanel">
                <div class="panelTitleContainer trendRecorderSettingsTitle">
                    <span id="trendRecorderSettingsTitle" class="translatableElement"></span>
                    <div id="toggleTrendSettingsPanelButton" class="toggleButton leftSideButton" onclick="showHidePanel('trendRecorderUserSettings', 'graphSettingsMenuOption', 'toggleTrendSettingsPanelButton', 'toggleOuterTrendSettingsPanelButton')">
                        <div class="buttonShape arrow-right"></div>
                    </div>
                </div>
                <div id="trendRecorderSettingsContainer">
                    <div id="UserSettings" class="panelSubDiv">
                        <div class="userSettingsLine" style="margin-right: 18px;">
                            <span id="currentTimeLabel" class="trendLabel titleText translatableElement"></span>
                            <input type="text" id="inputCurrentTime" class="inputPositiveFloat inputField trendRecorderInput graphSettingsTimeInput" value="0.0" />
                        </div>
                        <div class="userSettingsLine">
                            <span id="timeBaseLabel" class="trendLabel titleText translatableElement"></span>
                            <select id="inputTimeBase" class="trendRecorderSelect inputField">
                                <option value="1">1</option>
                                <option value="5">5</option>
                                <option value="10">10</option>
                                <option value="15">15</option>
                                <option value="30">30</option>
                                <option value="60">60</option>
                            </select>
                        </div>
                    </div>
                    <div id="cursorXSettings" class="panelSubDiv">
                        <div class="userSettingsLine">
                            <span id="cursorXStateLabel" class="trendLabel titleText translatableElement"></span>
                            <select id="inputCursorXState" class="trendRecorderSelect inputField">
                                <option value="false" id="inputCursorXStateOff" class="translatableElement"></option>
                                <option value="true" id="inputCursorXStateOn" class="translatableElement"></option>
                            </select>
                        </div>
                        <div class="userSettingsLine">
                            <span id="cursorX1PositionLabel" class="trendLabel titleText translatableElement"></span>
                            <input type="text" id="inputCursorX1Position" class="inputPositiveFloat inputField trendRecorderInput cursorXPosInput" value="0" disabled="disabled" />
                        </div>
                        <div class="userSettingsLine">
                            <span id="cursorX2PositionLabel" class="trendLabel titleText translatableElement"></span>
                            <input type="text" id="inputCursorX2Position" class="inputPositiveFloat inputField trendRecorderInput cursorXPosInput" value="0" disabled="disabled" />
                        </div>
                    </div>
                    <div id="cursorYSettings" class="panelSubDiv">
                        <div class="cursorYSettingsLine">
                            <span id="cursorYStateLabel" class="trendLabel titleText translatableElement"></span>
                            <select id="inputCursorYState" class="trendRecorderSelect inputField">
                                <option value="false" id="inputCursorYStateOff" class="translatableElement"></option>
                                <option value="true" id="inputCursorYStateOn" class="translatableElement"></option>
                            </select>
                        </div>
                        <div class="cursorYSettingsLine">
                            <span id="cursorY1UnitLabel" class="trendLabel titleText translatableElement"></span>
                            <select id="inputCursorYUnit" disabled="disabled" class="trendRecorderSelect inputField">
                                <%--dynamic filling--%>  
                            </select>
                        </div>
                        <div class="cursorYSettingsLine">
                            <span id="cursorY1PositionLabel" class="trendLabel titleText translatableElement"></span>
                            <input type="text" id="inputCursorY1Position" class="inputFloat inputField trendRecorderInput cursorYPosInput" value="0" disabled="disabled" />
                        </div>
                        <div class="cursorYSettingsLine">
                            <span id="cursorY2PositionLabel" class="trendLabel titleText translatableElement"></span>
                            <input type="text" id="inputCursorY2Position" class="inputFloat inputField trendRecorderInput cursorYPosInput" value="0" disabled="disabled" />
                        </div>
                    </div>
                </div>
            </div>
            <div id="toggleOuterTrendSettingsPanelButton" class="outerRightPanelButton translatableElement" title="" onclick="showHidePanel('trendRecorderUserSettings', 'graphSettingsMenuOption', 'toggleTrendSettingsPanelButton', 'toggleOuterTrendSettingsPanelButton')">
                <div class="toggleArrow arrow-left-large"></div>
            </div>
        </div>
        <div id="footerBar">
            <div class="footerBarElement">
                <div id="inputSourceBar">
                    <span id="footerSourceLabel" class="largeFooterText translatableElement"></span>
                    <span id="footerSourceChosenLabel" class="largeFooterText"></span>
                </div>
            </div>
        </div>

        <div id="createMeterDialog" title="" style="display: none; position: relative;">
            <br />
            <table>
                <tr>
                    <td style="padding-right: 5px"><span id="createMeterLabelLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="meterLabel" class="inputField" /></td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="createrMeterSourceLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <select id="sourceMeterSelect" class="typeDropDown inputField" onchange="populateMeterLabel()">
                            <%--dynamic filling--%>                            
                        </select>
                    </td>
                </tr>
            </table>
        </div>

        <a id="saveFile" style="display: none;" />
        <a id="downloadFile" href="help/Using LVProSim.pdf" style="display: none;" />

        <div id="setChannelDialog" title="" style="display: none; position: relative;">
            <br />
            <table>
                <div id="setChannelsWarning" class="warningText"></div>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelChannelLabel" class="titleText translatableElement"></span></td>
                    <td id="channelLine">
                        <select id="channelIds" class="channelDropDown inputField">
                            <%--dynamic filling--%> 
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelLabelLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="inputLabel" class="inputField" /></td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelTypeLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <select id="channelTypes" class="typeDropDown inputField" onchange="showCurrentUnits();">
                            <%--dynamic filling--%> 
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelUnitLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <select id="channelUnits" class="unitDropDown inputField" onchange="setMinMaxIfSpecialUnit();">
                            <%--dynamic filling--%>                           
                        </select>
                        <select id="channelRates" class="RateDropDown inputField">
                            <%--dynamic filling--%>                           
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelMinValueLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="inputMinValue" class="inputFloat inputField meterNumberInput" /></td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelMaxValueLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="inputMaxValue" class="inputFloat inputField meterNumberInput" /></td>
                </tr>

                <tr>
                    <br>
                    <td style="padding-right: 5px"><span id="setChannelEnableFilterLabel" class="titleText translatableElement"></span>
                        <input type="checkbox" id="filterEnabledCheckbox" onchange="toggleFilterOnChannelOption()" /></td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setChannelFilterLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="filterValue" class="inputFloat inputField meterNumberInput" /></td>
                </tr>
            </table>
        </div>

        <div id="setGeneratorDialog" title="" style="display: none; position: relative;">
            <br />
            <table>
                <div id="setGeneratorWarning" class="warningText"></div>
                <tr>
                    <td style="padding-right: 5px"><span id="setGeneratorTypeLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <select id="GeneratorTypes" class="typeDropDown inputField generatorInputField" onchange="updateGeneratorDisplay(this);">
                            <option value="SINUS" id="setGeneratorSinusTypeLabel" class="translatableElement"></option>
                            <option value="SQUARE" id="setGeneratorSquareTypeLabel" class="translatableElement"></option>
                            <option value="TRIANGULAR" id="setGeneratorTriangleTypeLabel" class="translatableElement"></option>
                            <option value="STEP" id="setGeneratorStepTypeLabel" class="translatableElement">Step</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setGeneratorAmplitudeLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="inputAmplitudeValue" class="inputPositiveFloat inputField meterNumberInput generatorInputField" onchange="updateGeneratorDisplay(this);" /></td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setGeneratorOffsetLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="inputOffsetValue" class="inputFloat inputField meterNumberInput generatorInputField" onchange="updateGeneratorDisplay(this);" /></td>
                </tr>
                <tr>
                    <td style="padding-right: 5px"><span id="setGeneratorPeriodLabel" class="titleText translatableElement"></span></td>
                    <td>
                        <input type="text" id="inputPeriodValue" class="inputPositiveFloat inputField meterNumberInput generatorInputField" onchange="updateGeneratorDisplay(this);" /></td>
                </tr>
            </table>
        </div>


        <div id="exportDialog" title="" style="display: none; position: relative;">
            <span id="exportDialogFileLabel" class="translatableElement"></span>
            <input type="text" id="exportDialogFilename" class="inputField" />
        </div>

        <div id="customDialog" title="" class="dialog" style="display: none;">
        </div>


        <div id="setFunctionDialog" title="" style="display: none; position: relative;">
            <div id="setFunctionsWarning" class="warningText"></div>
            <span id="setFunctionFunctionLabel" class="functionText translatableElement"></span>
            <select id="functionSelect" size="2" class="inputField" onchange="onFunctionSelect()">
                <%--dynamic filling--%>
            </select><br />
            <input type="button" id="buttonNewFunction" onclick="onClickNewFunction()" value="" class="buttonFunction functionText translatableElement" />
            <input type="button" id="buttonDeleteFunction" onclick="onClickDeleteFunction()" value="" class="buttonFunction functionText translatableElement" />
            <br />
            <div id="NewEditFunctionDiv" title="" class="dialog">
                <div>
                    <span id="setFunctionLabelLabel" class="functionText translatableElement"></span>
                    <br />
                    <input type="text" id="currentFunctionLabel" class="functionTextBox inputField" value="" />
                    <input type="button" id="buttonCreateFunction" onclick="onClickCreateFunction()" value="" class="buttonFunction buttonPushDataFunction functionText translatableElement" />
                    <input type="button" id="buttonEditFunction" onclick="onClickEditFunction()" value="" class="buttonFunction buttonPushDataFunction functionText translatableElement" />
                    <span id="invalidFunctionWarning" class="functionText translatableElement"></span>
                </div>

                <div class="divFuncElement">
                    <span id="setFunctionLeftValueLabel" class="functionText translatableElement"></span>
                    <br />
                    <select id="leftElementSelector" onchange="onChangeValOrOp()" class="chanAndFuncSelect inputField">
                        <%--dynamic filling--%>
                    </select>
                </div>
                <div class="divFuncElement">
                    <span id="setFunctionOperatorLabel" class="functionText translatableElement"></span>
                    <br />
                    <select id="operatorSelector" onchange="onChangeValOrOp()" class="chanAndFuncSelect inputField">
                        <%--dynamic filling--%>
                    </select>
                </div>
                <div class="divFuncElement">
                    <span id="setFunctionRightValueLabel" class="functionText translatableElement"></span>
                    <br />
                    <select id="rightElementSelector" onchange="onChangeValOrOp()" class="chanAndFuncSelect inputField">
                        <%--dynamic filling--%>
                    </select>
                </div>
                <span class="functionText">=</span>
                <div class="divFuncElement">
                    <span id="setFunctionResultLabel" class="functionText translatableElement"></span>
                    <br />
                    <input type="text" id="resultFunction" class="functionTextBox inputField" value="" readonly="readonly" />
                </div>
                <div class="divFuncElement">
                    <span id="setFunctionUnitLabel" class="functionText translatableElement"></span>
                    <br />
                    <input type="text" id="unitFunction" class="functionTextBox inputField" value="" />
                </div>
                <br />
            </div>
        </div>

        <div id="customValueDialog" title="" class="dialog" style="display: none;">
            <br />
            <tr>
                <td style="padding-right: 5px"><span id="setCustomValueLabel" class="titleText translatableElement"></span></td>
                <td>
                    <input type="text" id="customValueInput" class="inputFloat inputField" /></td>
            </tr>
        </div>
    </div>

    <%=AddScripts() %>
</body>
</html>
